//#############################################################################
//
// FILE:   main.c
//
// TITLE:  Universal Empty Project
//
// Universal Empty Project Example
//
// This example is an empty project setup for Driverlib development.
//!
//!  \note This example project has support for migration across our C2000 
//!  device families. If you are wanting to build this project from launchpad
//!  or controlCARD, please specify in the .syscfg file the board you're using.
//!  At any time you can select another device to migrate this example.
//
//#############################################################################
//
//
// $Copyright:
// Copyright (C) 2024 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//#############################################################################

//
// Included Files
//
#include  <stdint.h>
#include "driverlib.h"
#include "device.h"
#include "board.h"
#include "c2000ware_libraries.h"

#include "r_eeprom.h"
#include  "sta_test.h"


static void  main_core_tests(void);

//
// Main
//
void main(void)
{

    //
    // Initialize device clock and peripherals
    //
    Device_init();

    //
    // Disable pin locks and enable internal pull-ups.
    //
    Device_initGPIO();

    //
    // Initialize PIE and clear PIE registers. Disables CPU interrupts.
    //
    Interrupt_initModule();

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    //
    Interrupt_initVectorTable();

    //
    // PinMux and Peripheral Initialization
    //
    Board_init();

    //
    // C2000Ware Library initialization
    //
    C2000Ware_libraries_init();

    //
    // Enable Global Interrupt (INTM) and real time interrupt (DBGM)
    //
    EINT;
    ERTM;

    //**  Functional for the bug to happen
    //**
    static volatile uint16_t dummy_vec[38] = {0,};

    main_core_tests();


    //  ... Rubbish, can be anything

    static RsConfig_t  cfg = { 0, };
    rs_eeprom_init();
    if (! rs_eeprom_read(&cfg))
    {
        cfg.e_type = 123u;
        cfg.o_control = dummy_vec[1];
        
        rs_eeprom_write(&cfg);
    }

    while(1)
    {
        
    }
}


#define  DEBUG_MARK2_ON()       GPIO_writePin(SIGNAL_PIN, 0u)
#define  DEBUG_MARK2_OFF()      GPIO_writePin(SIGNAL_PIN, 1u)
#define  DEBUG_MARK2_TOGGLE()   GPIO_togglePin(SIGNAL_PIN)


static inline void  main_core_tests(void)
{
    static STA_TestType_t  test_item = STA_TEST_START;

    DEBUG_MARK2_ON();
    
    do {        
        DEBUG_MARK2_TOGGLE();   //**  Functional for the bug to happen
                                //**  Disabling/moving the line above 
                                //**  restores expected behavior
        //** Bug: test_item isn't read from RAM into AL, keeps being AL = 0
    	if (STA_CoreTest(test_item) != STA_TEST_PASS)
    	{
    		ESTOP0;
        	for (;;) {}
    	}

        // test_item is incremented correctly here
    } while (++test_item <= STA_TEST_END);

    DEBUG_MARK2_OFF();
}




//
// End of File
//

